<?php
defined('_JEXEC') or die;

// All variables are now passed from the main module file
?>

<?php if ($showDate || $showTime): ?>
<div id="<?php echo $moduleId; ?>" class="date-display-wrapper">
    <div class="date-display <?php echo $position; ?>">
        <?php if ($showDate): ?>
        <span class="date-content" style="color: <?php echo $dateColor; ?>; font-size: <?php echo $dateFontSize; ?>;"><?php echo htmlspecialchars($date, ENT_QUOTES, 'UTF-8'); ?></span>
        <?php endif; ?>
        <?php if ($showTime): ?>
        <span class="time-display" style="color: <?php echo $timeColor; ?>; font-size: <?php echo $timeFontSize; ?>;" id="<?php echo $moduleId; ?>-time">
            <?php echo htmlspecialchars($time, ENT_QUOTES, 'UTF-8'); ?>
        </span>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>

<?php if ($showTime): ?>
<script>
(function() {
    const timeElement = document.getElementById('<?php echo $moduleId; ?>-time');
    if (!timeElement) return;
    
    function updateTime() {
        const now = new Date();
        const timeString = now.toTimeString().split(' ')[0];
        timeElement.textContent = timeString;
    }
    
    // Update immediately and then every second
    updateTime();
    setInterval(updateTime, 1000);
})();
</script>
<?php endif; ?>

<style>
#<?php echo $moduleId; ?> {
    font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial, sans-serif;
    margin: 10px 0;
}

#<?php echo $moduleId; ?> .date-display-wrapper {
    display: flex;
    align-items: center;
    gap: 10px;
}

#<?php echo $moduleId; ?> .date-display {
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: 500;
    line-height: 1.4;
}

<?php if (!$showDate): ?>
#<?php echo $moduleId; ?> .date-display {
    justify-content: center;
}
<?php endif; ?>

<?php if (!$showTime): ?>
#<?php echo $moduleId; ?> .date-content {
    margin: 0;
}
<?php endif; ?>

#<?php echo $moduleId; ?> .date-display.left {
    justify-content: flex-start;
}

#<?php echo $moduleId; ?> .date-display.center {
    justify-content: center;
    width: 100%;
}

#<?php echo $moduleId; ?> .date-display.right {
    justify-content: flex-end;
    width: 100%;
}

#<?php echo $moduleId; ?> .date-content {
    font-weight: 600;
    white-space: nowrap;
}

#<?php echo $moduleId; ?> .time-display {
    font-weight: 500;
    font-family: 'Courier New', monospace;
    white-space: nowrap;
    padding: 2px 6px;
    background: rgba(0,0,0,0.05);
    border-radius: 4px;
}

/* Responsywność */
@media (max-width: 768px) {
    #<?php echo $moduleId; ?> .date-display {
        gap: 6px;
        flex-wrap: wrap;
    }
    
    #<?php echo $moduleId; ?> .date-display.center,
    #<?php echo $moduleId; ?> .date-display.right {
        justify-content: center;
    }
    
    <?php if ($showDate): ?>
    #<?php echo $moduleId; ?> .date-content {
        font-size: calc(<?php echo $dateFontSize; ?> * 0.9) !important;
    }
    <?php endif; ?>
    
    <?php if ($showTime): ?>
    #<?php echo $moduleId; ?> .time-display {
        font-size: calc(<?php echo $timeFontSize; ?> * 0.85) !important;
        padding: 1px 4px;
    }
    <?php endif; ?>
}

@media (max-width: 480px) {
    #<?php echo $moduleId; ?> .date-display {
        flex-direction: column;
        align-items: flex-start;
        gap: 4px;
    }
    
    #<?php echo $moduleId; ?> .date-display.center {
        align-items: center;
    }
    
    #<?php echo $moduleId; ?> .date-display.right {
        align-items: flex-end;
    }
    
    <?php if ($showDate): ?>
    #<?php echo $moduleId; ?> .date-content {
        font-size: calc(<?php echo $dateFontSize; ?> * 0.8) !important;
    }
    <?php endif; ?>
    
    <?php if ($showTime): ?>
    #<?php echo $moduleId; ?> .time-display {
        font-size: calc(<?php echo $timeFontSize; ?> * 0.75) !important;
    }
    <?php endif; ?>
}
</style>
