/**
 * Admin JavaScript for Date Display Module
 * Enhances toggle switches with modern styling
 */

document.addEventListener('DOMContentLoaded', function() {
    // Find all radio button groups with yesno class
    const toggleGroups = document.querySelectorAll('.btn-group-yesno');
    
    toggleGroups.forEach(function(group) {
        // Add modern toggle styling
        group.classList.add('modern-toggle');
        
        const radioButtons = group.querySelectorAll('input[type="radio"]');
        const labels = group.querySelectorAll('label');
        
        // Style the toggle group
        group.style.display = 'inline-flex';
        group.style.borderRadius = '20px';
        group.style.overflow = 'hidden';
        group.style.border = '2px solid #007cba';
        group.style.backgroundColor = '#f8f9fa';
        
        labels.forEach(function(label, index) {
            label.style.margin = '0';
            label.style.padding = '8px 16px';
            label.style.cursor = 'pointer';
            label.style.transition = 'all 0.3s ease';
            label.style.fontSize = '14px';
            label.style.fontWeight = '500';
            label.style.border = 'none';
            label.style.backgroundColor = 'transparent';
            
            // Check if this option is selected
            const radio = radioButtons[index];
            if (radio && radio.checked) {
                label.style.backgroundColor = '#007cba';
                label.style.color = '#ffffff';
            } else {
                label.style.backgroundColor = 'transparent';
                label.style.color = '#495057';
            }
            
            // Add hover effects
            label.addEventListener('mouseenter', function() {
                if (!radio.checked) {
                    label.style.backgroundColor = 'rgba(0, 124, 186, 0.1)';
                }
            });
            
            label.addEventListener('mouseleave', function() {
                if (!radio.checked) {
                    label.style.backgroundColor = 'transparent';
                }
            });
            
            // Handle selection changes
            radio.addEventListener('change', function() {
                labels.forEach(function(otherLabel) {
                    otherLabel.style.backgroundColor = 'transparent';
                    otherLabel.style.color = '#495057';
                });
                
                if (this.checked) {
                    label.style.backgroundColor = '#007cba';
                    label.style.color = '#ffffff';
                }
            });
        });
    });
});