<?php
defined('_JEXEC') or die;

// Load the Joomla framework
use Joomla\CMS\Helper\ModuleHelper;

// Load the helper functions from the module
require_once dirname(__FILE__) . '/helper.php';

// Get module parameters and data
$moduleId = 'mod-date-display-' . $module->id;
$showDate = (int) $params->get('show_date', 1);
$date = $showDate ? ModDateDisplayHelper::getDate($params) : '';
$showTime = (int) $params->get('show_time', 1);
$time = $showTime ? ModDateDisplayHelper::getTime() : '';
$position = htmlspecialchars($params->get('position', 'left'), ENT_QUOTES, 'UTF-8');
$dateColor = htmlspecialchars($params->get('date_color', '#000000'), ENT_QUOTES, 'UTF-8');
$timeColor = htmlspecialchars($params->get('time_color', '#000000'), ENT_QUOTES, 'UTF-8');
$dateFontSize = htmlspecialchars($params->get('date_font_size', '16px'), ENT_QUOTES, 'UTF-8');
$timeFontSize = htmlspecialchars($params->get('time_font_size', '14px'), ENT_QUOTES, 'UTF-8');

// Only display module if at least one element is enabled
if ($showDate || $showTime) {
    require ModuleHelper::getLayoutPath('mod_date_display', $params->get('layout', 'default'));
}
?>
