<?php
/**
 * @package     Date Display Module
 * @subpackage  mod_date_display
 * @copyright   Copyright (C) 2025 DiabloDesign. All rights reserved.
 * @license     GNU General Public License version 3 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

class mod_date_displayInstallerScript
{
    public function postflight($type, $parent)
    {
        if ($type !== 'install' && $type !== 'update') {
            return true;
        }

        $app = Factory::getApplication();
        $language = $app->getLanguage();
        
        $isPolish = ($language->getTag() === 'pl-PL');
        
        if ($isPolish) {
            $title = 'Moduł Date Display został pomyślnie zainstalowany!';
            $copyright = 'Wszelkie prawa zastrzeżone.';
            $license = 'Moduł jest oprogramowaniem open-source wydanym na licencji GNU/GPL.';
            $homepage = 'Strona domowa';
            $features = 'Nowe funkcje:';
            $feature1 = '✓ Konfigurowalny format daty i czasu';
            $feature2 = '✓ Wybór pozycji (lewo, środek, prawo)';
            $feature3 = '✓ Personalizowane kolory';
            $feature4 = '✓ Responsywny design';
            $feature5 = '✓ Zegar czasu rzeczywistego';
        } else {
            $title = 'Date Display module has been successfully installed!';
            $copyright = 'All rights reserved.';
            $license = 'The module is open-source software released under the GNU/GPL license.';
            $homepage = 'Homepage';
            $features = 'New features:';
            $feature1 = '✓ Configurable date and time format';
            $feature2 = '✓ Position selection (left, center, right)';
            $feature3 = '✓ Custom colors';
            $feature4 = '✓ Responsive design';
            $feature5 = '✓ Real-time clock';
        }
        
        $title = htmlspecialchars($title, ENT_QUOTES, 'UTF-8');
        $copyright = htmlspecialchars($copyright, ENT_QUOTES, 'UTF-8');
        $license = htmlspecialchars($license, ENT_QUOTES, 'UTF-8');
        $homepage = htmlspecialchars($homepage, ENT_QUOTES, 'UTF-8');
        $features = htmlspecialchars($features, ENT_QUOTES, 'UTF-8');
        $feature1 = htmlspecialchars($feature1, ENT_QUOTES, 'UTF-8');
        $feature2 = htmlspecialchars($feature2, ENT_QUOTES, 'UTF-8');
        $feature3 = htmlspecialchars($feature3, ENT_QUOTES, 'UTF-8');
        $feature4 = htmlspecialchars($feature4, ENT_QUOTES, 'UTF-8');
        $feature5 = htmlspecialchars($feature5, ENT_QUOTES, 'UTF-8');
        
        ?>
        <div style="text-align: center; padding: 20px; border: 1px solid #d2d2d2; background: #f5f5f5; border-radius: 8px; margin-top: 20px;">
            <a href="https://diablodesign.eu" target="_blank">
                <img src="https://diablodesign.eu/images/DiabloDesign/logo/logo-diablo-m.png" alt="DiabloDesign Logo" style="max-width: 250px; margin-bottom: 20px; border: 0;">
            </a>
            <h3><?php echo $title; ?></h3>
            <p><strong>&copy; <?php echo date('Y'); ?> DiabloDesign</strong>. <?php echo $copyright; ?></p>
            <p><?php echo $license; ?></p>
            
            <div style="margin: 20px 0; padding: 15px; background: #fff; border-radius: 6px; text-align: left; max-width: 400px; margin-left: auto; margin-right: auto;">
                <h4 style="margin-top: 0; color: #333;"><?php echo $features; ?></h4>
                <ul style="list-style: none; padding: 0; margin: 0;">
                    <li style="padding: 3px 0;"><?php echo $feature1; ?></li>
                    <li style="padding: 3px 0;"><?php echo $feature2; ?></li>
                    <li style="padding: 3px 0;"><?php echo $feature3; ?></li>
                    <li style="padding: 3px 0;"><?php echo $feature4; ?></li>
                    <li style="padding: 3px 0;"><?php echo $feature5; ?></li>
                </ul>
            </div>
            
            <p>
                <a href="https://diablodesign.eu" target="_blank" style="color: #007bff; text-decoration: none;"><?php echo $homepage; ?></a> | 
                <a href="https://github.com/DiabloDesign" target="_blank" style="color: #007bff; text-decoration: none;">GitHub</a>
            </p>
        </div>
        <?php
    }
}